<?php  
// index.php  
  
// 引入数据库配置信息  
require_once 'config.php';  
  
// 获取当前访问的域名  
$currentDomain = $_SERVER['HTTP_HOST'];  
  
// 准备SQL查询，获取所有域名  
$query = "SELECT domain_name FROM domain";  
$stmt = $connection->prepare($query);  
$stmt->execute();  
$result = $stmt->get_result();  
  
// 检查是否有其他域名可用  
if ($result->num_rows > 0) {  
    // 获取所有域名数组  
    $domains = [];  
    while ($row = $result->fetch_assoc()) {  
        $domains[] = $row['domain_name'];  
    }  
  
    // 移除当前域名  
    $domains = array_diff($domains, [$currentDomain]);  
  
    // 如果还有剩余域名，随机选择一个  
    if (!empty($domains)) {  
        $randomDomain = $domains[array_rand($domains)];  
  
        // 重定向到随机域名的redirect.php  
        header("Location: http://$randomDomain/");  
        exit;  
    } else {  
        // 如果没有其他域名可用（除了当前域名），可以重定向到默认页面或显示错误  
        header("Location: /default.html");  
        exit;  
    }  
} else {  
    // 如果没有其他域名，可以重定向到默认页面或显示错误  
    header("Location: /default.html");  
    exit;  
}  
  
// 关闭数据库连接  
$connection->close();  
?>