<?php
include 'config.php'; // 引入数据库配置信息

// 处理添加域名的逻辑
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['addDomain'])) {
    $domainName = $connection->real_escape_string($_POST['domainName']);
    $query = "INSERT INTO domain (domain_name) VALUES ('{$domainName}')";
    if ($connection->query($query) === TRUE) {
        // 添加成功，重定向到admin.php
        header('Location: admin.php');
        exit;
    } else {
        // 添加失败，重定向到admin.php并带上错误信息
        header('Location: admin.php?error=' . urlencode('添加域名失败：' . $connection->error));
        exit;
    }
}

// 处理删除域名的逻辑
if (isset($_GET['action']) && $_GET['action'] == 'deleteDomain' && isset($_GET['id'])) {
    $domainId = $connection->real_escape_string($_GET['id']);
    $query = "DELETE FROM domain WHERE id = {$domainId}";
    if ($connection->query($query) === TRUE) {
        // 删除成功，重定向到admin.php
        header('Location: admin.php');
        exit;
    } else {
        // 删除失败，重定向到admin.php并带上错误信息
        header('Location: admin.php?error=' . urlencode('删除域名失败：' . $connection->error));
        exit;
    }
}

// 处理添加链接的逻辑
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['addLink'])) {
    $linkUrl = $connection->real_escape_string($_POST['linkUrl']);
    $query = "INSERT INTO links (url) VALUES ('{$linkUrl}')";
    if ($connection->query($query) === TRUE) {
        // 添加成功，重定向到admin.php
        header('Location: admin.php');
        exit;
    } else {
        // 添加失败，重定向到admin.php并带上错误信息
        header('Location: admin.php?error=' . urlencode('添加链接失败：' . $connection->error));
        exit;
    }
}

// 处理删除链接的逻辑
if (isset($_GET['action']) && $_GET['action'] == 'deleteLink' && isset($_GET['id'])) {
    $linkId = $connection->real_escape_string($_GET['id']);
    $query = "DELETE FROM links WHERE id = {$linkId}";
    if ($connection->query($query) === TRUE) {
        // 删除成功，重定向到admin.php
        header('Location: admin.php');
        exit;
    } else {
        // 删除失败，重定向到admin.php并带上错误信息
        header('Location: admin.php?error=' . urlencode('删除链接失败：' . $connection->error));
        exit;
    }
}

// 获取域名和链接列表
$domainsQuery = "SELECT * FROM domain"; // 优化后的查询
$domainsResult = $connection->query($domainsQuery);

$linksQuery = "SELECT * FROM links"; // 优化后的查询
$linksResult = $connection->query($linksQuery);

// 开始输出HTML
?>
<!DOCTYPE html>
<html lang="zh-CN">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>网站管理后台</title>
    <!-- 引入合并后的CSS文件 -->
    <link rel="stylesheet" href="./admin.css">
    <link rel="stylesheet" href="./bootstrap.css">
    <!-- 引入合并后的JavaScript文件 -->
    <script src="./admin.js"></script>
</head>
<body>
    <div class="container">
        <!-- 添加域名和域名列表 -->
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0">域名管理</h5>
            </div>
            <div class="card-body">
                <form method="post">
                    <div class="form-group">
                        <label for="domainName">添加域名</label>
                        <input type="text" class="form-control" id="domainName" name="domainName" placeholder="输入域名" required>
                    </div>
                    <button type="submit" class="btn btn-primary" name="addDomain">添加域名</button>
                </form>
                <?php if (isset($_GET['error'])): ?>
                    <div class="alert alert-danger mt-3">
                        <?= htmlspecialchars($_GET['error'], ENT_QUOTES, 'UTF-8') ?>
                    </div>
                <?php endif; ?>
                <table class="table mt-3">
                    <thead>
                        <tr>
                            <th scope="col">域名</th>
                            <th scope="col">操作</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php while ($domain = $domainsResult->fetch_assoc()): ?>
                            <tr>
                                <td><?= htmlspecialchars($domain['domain_name']) ?></td>
                                <td>
                                    <a href="admin.php?action=deleteDomain&id=<?= $domain['id'] ?>" onclick="return confirm('确定要删除吗？')">删除</a>
                                </td>
                            </tr>
                        <?php endwhile; ?>
                        <?php if ($domainsResult->num_rows == 0): ?>
                            <tr>
                                <td colspan="2">没有域名记录</td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>

        <!-- 添加链接和链接列表 -->
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0">链接管理</h5>
            </div>
            <div class="card-body">
                <form method="post">
                    <div class="form-group">
                        <label for="linkUrl">添加链接</label>
                        <input type="url" class="form-control" id="linkUrl" name="linkUrl" placeholder="输入链接地址" required>
                    </div>
                    <button type="submit" class="btn btn-primary" name="addLink">添加链接</button>
                </form>
                <?php if (isset($_GET['error'])): ?>
                    <div class="alert alert-danger mt-3">
                        <?= htmlspecialchars($_GET['error'], ENT_QUOTES, 'UTF-8') ?>
                    </div>
                <?php endif; ?>
                <table class="table mt-3">
                    <thead>
                        <tr>
                            <th scope="col">链接地址</th>
                            <th scope="col">操作</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php while ($link = $linksResult->fetch_assoc()): ?>
                            <tr>
                                <td><?= htmlspecialchars($link['url']) ?></td>
                                <td>
                                    <a href="admin.php?action=deleteLink&id=<?= $link['id'] ?>" onclick="return confirm('确定要删除吗？')">删除</a>
                                </td>
                            </tr>
                        <?php endwhile; ?>
                        <?php if ($linksResult->num_rows == 0): ?>
                            <tr>
                                <td colspan="2">没有链接记录</td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</body>
</html>

