// admin.js

// 文档准备就绪后执行的函数
$(document).ready(function() {

    // 处理删除操作的确认
    $('body').on('click', '.delete-confirm', function(e) {
        if (!confirm('确定要删除吗？')) {
            e.preventDefault();
        }
    });

    // 异步加载数据（如果需要）
    // 例如，您可以使用AJAX来加载或更新数据而不刷新整个页面
    // $.ajax({
    //     url: 'ajax-loader.php', // 您的AJAX处理程序的URL
    //     type: 'GET',
    //     dataType: 'json',
    //     success: function(data) {
    //         // 成功加载数据后的操作
    //         console.log(data);
    //     },
    //     error: function(jqXHR, textStatus, errorThrown) {
    //         // 处理错误情况
    //         console.error('AJAX请求失败:', textStatus, errorThrown);
    //     }
    // });

    // 表单提交处理（如果需要）
    // 例如，您可以使用AJAX来异步提交表单
    $('body').on('submit', '.ajax-form', function(e) {
        e.preventDefault(); // 阻止默认的表单提交行为
        $.ajax({
            url: $(this).attr('action'), // 表单的action属性指定的URL
            type: 'POST',
            data: $(this).serialize(), // 序列化表单数据
            dataType: 'json',
            success: function(response) {
                // 处理响应数据
                if (response.success) {
                    // 如果操作成功，可以重定向或更新页面
                    window.location.href = 'admin.php'; // 简单的重定向
                } else {
                    // 如果操作失败，显示错误信息
                    alert(response.error);
                }
            },
            error: function(jqXHR, textStatus, errorThrown) {
                // 处理错误情况
                console.error('AJAX请求失败:', textStatus, errorThrown);
            }
        });
    });

    // 其他可能的管理页面功能...

});