<?php
require_once '../core/functions.php';

if (isset($_SESSION['user_logged_in']) && $_SESSION['user_logged_in'] === true) {
    header('Location: home.php');
    exit;
}
?>
<!DOCTYPE html>
<html lang="zh-CN">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>用户中心 - &#20992;&#23458;&#28304;&#30721;&#32593;</title>
    <link rel="stylesheet" href="assets/style.css">
</head>
<body>
    <div class="user-container">
        <div class="form-box" id="login-box">
            <form id="login-form">
                <h2>用户登录</h2>
                <div id="login-error" class="error-msg"></div>
                <div class="form-group">
                    <input type="text" name="username" placeholder="用户名" required>
                </div>
                <div class="form-group">
                    <input type="password" name="password" placeholder="密码" required>
                </div>
                <button type="submit">登 录</button>
                <p class="switch-form">没有账号？ <a href="#" id="show-register">立即注册</a></p>
            </form>
        </div>

        <div class="form-box hidden" id="register-box">
            <form id="register-form">
                <h2>用户注册</h2>
                <div id="register-error" class="error-msg"></div>
                <div class="form-group">
                    <input type="text" name="username" placeholder="用户名 (3-15位字母或数字)" required pattern="[a-zA-Z0-9]{3,15}">
                </div>
                <div class="form-group">
                    <input type="password" name="password" placeholder="密码 (至少6位)" required minlength="6">
                </div>
                <div class="form-group">
                    <input type="password" name="confirm_password" placeholder="确认密码" required>
                </div>
                <button type="submit">注 册</button>
                <p class="switch-form">已有账号？ <a href="#" id="show-login">立即登录</a></p>
            </form>
        </div>
    </div>
    <script src="assets/script.js"></script>
</body>
</html>