<?php
require_once '../core/functions.php';
check_user_login();
require_once '../core/db.php';

$user_id = $_SESSION['user_id'];

$stmt = $pdo->prepare("SELECT * FROM users WHERE id = ?");
$stmt->execute([$user_id]);
$user = $stmt->fetch();

if (!$user) {
    header('Location: logout.php');
    exit;
}

$stmt_page = $pdo->prepare("SELECT * FROM user_pages WHERE user_id = ?");
$stmt_page->execute([$user_id]);
$user_page = $stmt_page->fetch();

if (!$user_page) {
    $insert_stmt = $pdo->prepare("INSERT INTO user_pages (user_id) VALUES (?)");
    $insert_stmt->execute([$user_id]);
    $stmt_page->execute([$user_id]);
    $user_page = $stmt_page->fetch();
}

$base_url = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? "https" : "http") . "://$_SERVER[HTTP_HOST]";
$project_path = dirname($_SERVER['PHP_SELF'], 2); 
$share_link = rtrim($base_url . $project_path, '/') . '/display.php?key=' . $user['unique_key'];
?>
<!DOCTYPE html>
<html lang="zh-CN">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>我的弹窗 - 用户中心</title>
    <link rel="stylesheet" href="assets/style.css">
</head>
<body>
    <div class="home-container">
        <header class="home-header">
            <h1>我的专属弹窗</h1>
            <p>欢迎, <strong><?php echo htmlspecialchars($user['username']); ?></strong>! <a href="logout.php">退出登录</a></p>
        </header>

        <div id="alert-container"></div>

        <div class="content-wrapper">
            <form id="user-settings-form">
                <div class="form-card">
                    <h3>弹窗内容</h3>
                    <div class="form-group">
                        <label for="custom_tips">自定义弹窗文字 (一行一个)</label>
                        <textarea id="custom_tips" name="custom_tips" rows="8"><?php echo htmlspecialchars($user_page['custom_tips'] ?? ''); ?></textarea>
                        <small>如果留空，将使用管理员设置的默认文字。</small>
                    </div>
                </div>

                <div class="form-card">
                    <h3>样式与效果</h3>
                     <div class="form-group">
                        <label for="background_color">页面背景色</label>
                        <input type="color" id="background_color" name="background_color" value="<?php echo htmlspecialchars($user_page['background_color'] ?? '#000000'); ?>">
                    </div>
                    <?php if ($user['can_use_music']): ?>
                    <div class="form-group">
                        <label for="music_url">背景音乐URL</label>
                        <input type="text" id="music_url" name="music_url" value="<?php echo htmlspecialchars($user_page['music_url'] ?? ''); ?>" placeholder="输入音乐API或直链">
                    </div>
                    <?php endif; ?>
                    <?php if ($user['can_use_effects']): ?>
                    <div class="form-group">
                        <label for="custom_code">自定义特效代码 (HTML/JS)</label>
                        <textarea id="custom_code" name="custom_code" rows="5"><?php echo htmlspecialchars($user_page['custom_code'] ?? ''); ?></textarea>
                    </div>
                     <?php endif; ?>
                </div>
                
                <button type="submit" class="save-btn">保存我的设置</button>
            </form>
            
            <?php if ($user['can_generate_link']): ?>
            <div class="share-link-card">
                <h3>你的专属链接</h3>
                <input type="text" id="share-link-input" value="<?php echo $share_link; ?>" readonly>
                <button id="copy-link-btn">复制链接</button>
            </div>
            <?php endif; ?>
        </div>
    </div>
    <script src="assets/script.js"></script>
</body>
</html>