document.addEventListener('DOMContentLoaded', function() {

    const showAlert = (message, type = 'success', containerId = 'alert-container') => {
        const container = document.getElementById(containerId);
        if (!container) return;
        const alertDiv = document.createElement('div');
        alertDiv.className = `alert alert-${type}`;
        alertDiv.textContent = message;
        container.innerHTML = '';
        container.appendChild(alertDiv);
        if (type === 'success') {
            setTimeout(() => {
                alertDiv.style.transition = 'opacity 0.5s';
                alertDiv.style.opacity = '0';
                setTimeout(() => alertDiv.remove(), 500);
            }, 2000);
        }
    };
    
    const showError = (message, containerId) => {
        const container = document.getElementById(containerId);
        if (container) {
            container.textContent = message;
            container.style.display = 'block';
        }
    };

    const sendRequest = (formData) => {
        return fetch('ajax.php', {
            method: 'POST',
            body: formData
        }).then(response => response.json());
    };

    // 登录/注册表单切换
    const loginBox = document.getElementById('login-box');
    const registerBox = document.getElementById('register-box');
    const showRegister = document.getElementById('show-register');
    const showLogin = document.getElementById('show-login');

    if (showRegister) {
        showRegister.addEventListener('click', (e) => {
            e.preventDefault();
            loginBox.classList.add('hidden');
            registerBox.classList.remove('hidden');
        });
    }
    if (showLogin) {
        showLogin.addEventListener('click', (e) => {
            e.preventDefault();
            registerBox.classList.add('hidden');
            loginBox.classList.remove('hidden');
        });
    }

    // 注册
    const registerForm = document.getElementById('register-form');
    if (registerForm) {
        registerForm.addEventListener('submit', function(e) {
            e.preventDefault();
            const password = this.elements['password'].value;
            const confirm_password = this.elements['confirm_password'].value;
            if (password !== confirm_password) {
                showError('两次输入的密码不一致', 'register-error');
                return;
            }
            const formData = new FormData(this);
            formData.append('action', 'register');
            sendRequest(formData).then(data => {
                if (data.status === 'success') {
                    alert('注册成功！请前往登录。');
                    window.location.reload();
                } else {
                    showError(data.message, 'register-error');
                }
            });
        });
    }

    // 登录
    const loginForm = document.getElementById('login-form');
    if (loginForm) {
        loginForm.addEventListener('submit', function(e) {
            e.preventDefault();
            const formData = new FormData(this);
            formData.append('action', 'login');
            sendRequest(formData).then(data => {
                if (data.status === 'success') {
                    window.location.href = 'home.php';
                } else {
                    showError(data.message, 'login-error');
                }
            });
        });
    }
    
    // 保存用户设置
    const userSettingsForm = document.getElementById('user-settings-form');
    if(userSettingsForm) {
        userSettingsForm.addEventListener('submit', function(e) {
            e.preventDefault();
            const formData = new FormData(this);
            formData.append('action', 'save_user_settings');
            sendRequest(formData).then(data => {
                showAlert(data.message, data.status);
            });
        });
    }
    
    // 复制链接
    const copyBtn = document.getElementById('copy-link-btn');
    if(copyBtn) {
        copyBtn.addEventListener('click', function() {
            const input = document.getElementById('share-link-input');
            input.select();
            input.setSelectionRange(0, 99999);
            document.execCommand('copy');
            this.textContent = '已复制!';
            setTimeout(() => { this.textContent = '复制链接'; }, 1500);
        });
    }
});