<?php
require_once '../core/functions.php';
require_once '../core/db.php';

header('Content-Type: application/json');

$action = $_POST['action'] ?? '';
$response = ['status' => 'error', 'message' => '无效的操作'];

try {
    switch ($action) {
        case 'register':
            $username = $_POST['username'] ?? '';
            $password = $_POST['password'] ?? '';
            $confirm_password = $_POST['confirm_password'] ?? '';
            
            if (!preg_match('/^[a-zA-Z0-9]{3,15}$/', $username)) {
                $response['message'] = '用户名必须是3-15位的字母或数字';
            } elseif (strlen($password) < 6) {
                $response['message'] = '密码长度不能少于6位';
            } elseif ($password !== $confirm_password) {
                $response['message'] = '两次输入的密码不一致';
            } else {
                $stmt = $pdo->prepare("SELECT id FROM users WHERE username = ?");
                $stmt->execute([$username]);
                if ($stmt->fetch()) {
                    $response['message'] = '该用户名已被注册';
                } else {
                    $hashed_password = password_hash($password, PASSWORD_DEFAULT);
                    $unique_key = md5(uniqid($username, true));
                    $stmt = $pdo->prepare("INSERT INTO users (username, password, unique_key) VALUES (?, ?, ?)");
                    $stmt->execute([$username, $hashed_password, $unique_key]);
                    $response = ['status' => 'success', 'message' => '注册成功！请登录。'];
                }
            }
            break;

        case 'login':
            $username = $_POST['username'] ?? '';
            $password = $_POST['password'] ?? '';
            $stmt = $pdo->prepare("SELECT * FROM users WHERE username = ?");
            $stmt->execute([$username]);
            $user = $stmt->fetch();
            if ($user && password_verify($password, $user['password'])) {
                $_SESSION['user_logged_in'] = true;
                $_SESSION['user_id'] = $user['id'];
                $_SESSION['user_username'] = $user['username'];
                $response = ['status' => 'success', 'message' => '登录成功'];
            } else {
                $response['message'] = '用户名或密码错误';
            }
            break;
            
        case 'save_user_settings':
            if (!isset($_SESSION['user_logged_in'])) {
                $response['message'] = '请先登录';
                break;
            }
            $user_id = $_SESSION['user_id'];
            $data = [
                'custom_tips' => $_POST['custom_tips'] ?? '',
                'background_color' => $_POST['background_color'] ?? '#000000',
                'music_url' => $_POST['music_url'] ?? null,
                'custom_code' => $_POST['custom_code'] ?? null,
            ];
            
            $stmt = $pdo->prepare("UPDATE user_pages SET custom_tips = :custom_tips, background_color = :background_color, music_url = :music_url, custom_code = :custom_code WHERE user_id = :user_id");
            $data['user_id'] = $user_id;
            $stmt->execute($data);
            $response = ['status' => 'success', 'message' => '设置已保存'];
            break;
    }
} catch (Exception $e) {
    $response['message'] = '服务器错误: ' . $e->getMessage();
}

echo json_encode($response);
?>