<!DOCTYPE html>
<html lang="zh-CN">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>温馨提示</title>
    <style>
        body { margin: 0; overflow: hidden; height: 100vh; background-color: <?php echo htmlspecialchars($data['bodyBgColor']); ?>; }
        .window { position: absolute; width: 250px; border: 1px solid #ccc; border-radius: 5px; box-shadow: 2px 2px 10px rgba(0,0,0,0.2); font-family: '微软雅黑', sans-serif; cursor: move; z-index: 1000; overflow: hidden; animation: popupAnimation 0.3s ease-out forwards; opacity: 0; transform: scale(0.8); }
        @keyframes popupAnimation { to { opacity: 1; transform: scale(1); } }
        .window-title-bar { background-color: #f0f0f0; padding: 5px 10px; display: flex; justify-content: space-between; align-items: center; border-bottom: 1px solid #ccc; cursor: move; }
        .window-title { font-size: 14px; color: #333; }
        .window-controls { display: flex; gap: 5px; }
        .window-control-btn { width: 16px; height: 16px; border-radius: 50%; border: none; cursor: pointer; font-size: 10px; display: flex; align-items: center; justify-content: center; line-height: 1; padding: 0; }
        .close-btn { background-color: #ff5f57; }
        .min-btn { background-color: #ffbd2e; }
        .max-btn { background-color: #28c940; }
        .window-content { padding: 15px; font-size: 16px; text-align: center; min-height: 60px; display: flex; align-items: center; justify-content: center; box-sizing: border-box; }
    </style>
</head>
<body>
    <?php if (!empty($data['musicUrl'])): ?>
        <audio id="bg-music" src="<?php echo htmlspecialchars($data['musicUrl']); ?>" autoplay loop></audio>
    <?php endif; ?>

    <script>
        const tips = <?php echo json_encode($data['tips'], JSON_UNESCAPED_UNICODE); ?>;
        const bgColors = <?php echo json_encode(array_filter(array_map('trim', $data['bgColors'])), JSON_UNESCAPED_UNICODE); ?>;

        function makeDraggable(element) {
            let pos1 = 0, pos2 = 0, pos3 = 0, pos4 = 0;
            const titleBar = element.querySelector('.window-title-bar');

            if (titleBar) {
                titleBar.onmousedown = dragMouseDown;
            }

            function dragMouseDown(e) {
                e = e || window.event;
                e.preventDefault();
                pos3 = e.clientX;
                pos4 = e.clientY;
                document.onmouseup = closeDragElement;
                document.onmousemove = elementDrag;
            }

            function elementDrag(e) {
                e = e || window.event;
                e.preventDefault();
                pos1 = pos3 - e.clientX;
                pos2 = pos4 - e.clientY;
                pos3 = e.clientX;
                pos4 = e.clientY;
                element.style.top = (element.offsetTop - pos2) + "px";
                element.style.left = (element.offsetLeft - pos1) + "px";
            }

            function closeDragElement() {
                document.onmouseup = null;
                document.onmousemove = null;
            }
        }

        function createPopup() {
            if (tips.length === 0) return;

            const popup = document.createElement('div');
            popup.className = 'window';
            
            const titleBarHTML = `
                <div class="window-title-bar">
                    <div class="window-title">温馨提示</div>
                    <div class="window-controls">
                        <button class="window-control-btn min-btn"></button>
                        <button class="window-control-btn max-btn"></button>
                        <button class="window-control-btn close-btn"></button>
                    </div>
                </div>`;

            const content = document.createElement('div');
            content.className = 'window-content';
            
            const bgColor = bgColors.length > 0 ? bgColors[Math.floor(Math.random() * bgColors.length)] : 'lightblue';
            content.style.backgroundColor = bgColor;

            const tip = tips[Math.floor(Math.random() * tips.length)];
            content.textContent = tip;

            popup.innerHTML = titleBarHTML;
            popup.appendChild(content);

            const screenWidth = window.innerWidth;
            const screenHeight = window.innerHeight;
            const popupWidth = 250;
            const popupHeight = 120;
            const x = Math.random() * (screenWidth - popupWidth);
            const y = Math.random() * (screenHeight - popupHeight);

            popup.style.left = `${x}px`;
            popup.style.top = `${y}px`;

            popup.querySelector('.close-btn').addEventListener('click', () => popup.remove());
            
            popup.querySelector('.min-btn').addEventListener('click', () => popup.style.display = 'none');
            popup.querySelector('.max-btn').addEventListener('click', () => {
                 popup.style.width = '90vw';
                 popup.style.height = '80vh';
                 popup.style.left = '5vw';
                 popup.style.top = '10vh';
            });

            document.body.appendChild(popup);
            makeDraggable(popup);
        }

        let popupInterval;
        function startPopupCycle() {
            if (popupInterval) clearInterval(popupInterval);
            for (let i = 0; i < 10; i++) {
                setTimeout(createPopup, i * 200);
            }
            popupInterval = setInterval(createPopup, 500);
        }

        window.addEventListener('load', startPopupCycle);

        document.addEventListener('keydown', (e) => {
            if (e.code === 'Space') {
                document.querySelectorAll('.window').forEach(w => w.remove());
                startPopupCycle();
            }
        });
        
        document.body.addEventListener('click', () => {
            const music = document.getElementById('bg-music');
            if(music && music.paused) {
                music.play().catch(e => console.log("Music autoplay failed."));
            }
        }, { once: true });

    </script>
    
    <?php if (!empty($data['customCode'])): ?>
        <?php echo $data['customCode']; ?>
    <?php endif; ?>
</body>
</html>