<?php
require_once 'core/db.php';
require_once 'core/functions.php';

anti_bot_check();

$key = $_GET['key'] ?? '';
if (empty($key)) {
    die('无效的访问链接。');
}

$stmt = $pdo->prepare("SELECT * FROM users WHERE unique_key = ?");
$stmt->execute([$key]);
$user = $stmt->fetch();

if (!$user) {
    die('链接不存在或已被删除。');
}

$stmt_page = $pdo->prepare("SELECT * FROM user_pages WHERE user_id = ?");
$stmt_page->execute([$user['id']]);
$user_page = $stmt_page->fetch();

$settings = get_all_settings($pdo);

$final_tips = !empty(trim($user_page['custom_tips'])) ? explode("\n", str_replace("\r", "", $user_page['custom_tips'])) : $pdo->query("SELECT content FROM tips")->fetchAll(PDO::FETCH_COLUMN);
$final_music = $user['can_use_music'] && !empty($user_page['music_url']) ? $user_page['music_url'] : ($settings['music_api'] ?? null);
$final_code = $user['can_use_effects'] && !empty($user_page['custom_code']) ? $user_page['custom_code'] : ($settings['custom_code'] ?? null);

$data = [
    'tips' => $final_tips,
    'bgColors' => explode(',', $settings['popup_colors']),
    'bodyBgColor' => $user_page['background_color'] ?? '#000000',
    'musicUrl' => $final_music,
    'customCode' => $final_code,
];

include 'templates/popup_template.php';
?>