<?php
session_start();

function check_admin_login() {
    if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
        header('Location: index.php');
        exit;
    }
}

function check_user_login() {
    if (!isset($_SESSION['user_logged_in']) || $_SESSION['user_logged_in'] !== true) {
        header('Location: index.php');
        exit;
    }
}

function get_all_settings($pdo) {
    $stmt = $pdo->query("SELECT setting_key, setting_value FROM settings");
    $settings = $stmt->fetchAll(PDO::FETCH_KEY_PAIR);
    return $settings;
}

function anti_bot_check() {
    $user_agent = $_SERVER['HTTP_USER_AGENT'] ?? '';
    $bots = ['bot', 'spider', 'crawl', 'slurp', 'mediapartners-google'];
    foreach ($bots as $bot) {
        if (stripos($user_agent, $bot) !== false) {
            header('HTTP/1.1 403 Forbidden');
            die('Access Denied.');
        }
    }
}
?>