<?php
require_once '../core/functions.php';
check_admin_login();
require_once '../core/db.php';

$users = $pdo->query("SELECT * FROM users ORDER BY id DESC")->fetchAll();
$page_title = "用户管理";
?>
<!DOCTYPE html>
<html lang="zh-CN">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $page_title; ?> - 后台管理</title>
    <link rel="stylesheet" href="assets/style.css">
</head>
<body>
    <div class="admin-wrapper">
        <?php include '_sidebar.php'; ?>
        <div class="main-content">
            <div class="content-header">
                <h1><?php echo $page_title; ?></h1>
            </div>
            <div id="alert-container"></div>
            <div class="card">
                <table class="table">
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th>用户名</th>
                            <th>专属KEY</th>
                            <th>音乐权限</th>
                            <th>特效权限</th>
                            <th>链接权限</th>
                            <th>操作</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($users as $user): ?>
                        <tr data-id="<?php echo $user['id']; ?>">
                            <td><?php echo $user['id']; ?></td>
                            <td><?php echo htmlspecialchars($user['username']); ?></td>
                            <td><?php echo $user['unique_key']; ?></td>
                            <td>
                                <label class="switch">
                                    <input type="checkbox" class="permission-toggle" data-permission="can_use_music" <?php echo $user['can_use_music'] ? 'checked' : ''; ?>>
                                    <span class="slider"></span>
                                </label>
                            </td>
                             <td>
                                <label class="switch">
                                    <input type="checkbox" class="permission-toggle" data-permission="can_use_effects" <?php echo $user['can_use_effects'] ? 'checked' : ''; ?>>
                                    <span class="slider"></span>
                                </label>
                            </td>
                             <td>
                                <label class="switch">
                                    <input type="checkbox" class="permission-toggle" data-permission="can_generate_link" <?php echo $user['can_generate_link'] ? 'checked' : ''; ?>>
                                    <span class="slider"></span>
                                </label>
                            </td>
                            <td>
                                <button class="btn btn-danger btn-sm delete-user">删除</button>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
    <script src="assets/script.js"></script>
</body>
</html>