<?php
require_once '../core/functions.php';
check_admin_login();
require_once '../core/db.php';

$settings = get_all_settings($pdo);
$tips = $pdo->query("SELECT id, content FROM tips ORDER BY id DESC")->fetchAll();

$page_title = "全局设置";
?>
<!DOCTYPE html>
<html lang="zh-CN">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $page_title; ?> - 后台管理</title>
    <link rel="stylesheet" href="assets/style.css">
</head>
<body>
    <div class="admin-wrapper">
        <?php include '_sidebar.php'; ?>
        <div class="main-content">
            <div class="content-header">
                <h1><?php echo $page_title; ?></h1>
            </div>
            <div id="alert-container"></div>
            <div class="card">
                <div class="card-header"><h2>基础设置</h2></div>
                <form id="settings-form">
                    <div class="form-row">
                        <label for="music_api">音乐API接口</label>
                        <input type="text" id="music_api" name="music_api" value="<?php echo htmlspecialchars($settings['music_api'] ?? ''); ?>" placeholder="留空则不启用背景音乐">
                    </div>
                    <div class="form-row">
                        <label for="frontend_bg_color">前端全局背景色</label>
                        <input type="text" id="frontend_bg_color" name="frontend_bg_color" value="<?php echo htmlspecialchars($settings['frontend_bg_color'] ?? '#000000'); ?>">
                    </div>
                    <div class="form-row">
                        <label for="popup_colors">弹窗随机背景色</label>
                        <textarea id="popup_colors" name="popup_colors" placeholder="每种颜色用英文逗号,隔开"><?php echo htmlspecialchars($settings['popup_colors'] ?? ''); ?></textarea>
                    </div>
                    <div class="form-row">
                        <label for="custom_code">全局特效代码 (HTML/JS)</label>
                        <textarea id="custom_code" name="custom_code" placeholder="会插入到前端页面的<body>标签底部"><?php echo htmlspecialchars($settings['custom_code'] ?? ''); ?></textarea>
                    </div>
                    <button type="submit" class="btn btn-primary">保存设置</button>
                </form>
            </div>
            <div class="card">
                <div class="card-header"><h2>弹窗文字管理</h2></div>
                <form id="add-tip-form" class="form-row">
                     <input type="text" name="tip_content" placeholder="在此输入新的弹窗文字" required>
                     <button type="submit" class="btn btn-primary">添加</button>
                </form>
                <table class="table" id="tips-table">
                    <thead><tr><th>内容</th><th width="80">操作</th></tr></thead>
                    <tbody>
                        <?php foreach ($tips as $tip): ?>
                        <tr data-id="<?php echo $tip['id']; ?>">
                            <td><?php echo htmlspecialchars($tip['content']); ?></td>
                            <td><button class="btn btn-danger btn-sm delete-tip">删除</button></td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
            <div class="card">
                <div class="card-header"><h2>修改管理员密码</h2></div>
                <form id="password-form">
                    <div class="form-row">
                        <label for="new_password">新密码</label>
                        <input type="password" id="new_password" name="new_password" required>
                    </div>
                    <div class="form-row">
                        <label for="confirm_password">确认新密码</label>
                        <input type="password" id="confirm_password" name="confirm_password" required>
                    </div>
                    <button type="submit" class="btn btn-primary">修改密码</button>
                </form>
            </div>
        </div>
    </div>
    <script src="assets/script.js"></script>
</body>
</html>