<?php
require_once '../core/functions.php';
check_admin_login();

$template_path = '../templates/popup_template.php';
$template_content = file_exists($template_path) ? file_get_contents($template_path) : '模板文件不存在，请检查路径。';

$page_title = "模板编辑";
?>
<!DOCTYPE html>
<html lang="zh-CN">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $page_title; ?> - 后台管理</title>
    <link rel="stylesheet" href="assets/style.css">
    <style>
        #editor { width: 100%; height: 60vh; font-family: monospace; font-size: 14px; border: 1px solid #ddd; border-radius: 4px; padding: 10px; box-sizing: border-box; }
    </style>
</head>
<body>
    <div class="admin-wrapper">
        <?php include '_sidebar.php'; ?>
        <div class="main-content">
            <div class="content-header">
                <h1><?php echo $page_title; ?></h1>
                <p>正在编辑: <strong>templates/popup_template.php</strong></p>
            </div>
            <div id="alert-container"></div>
            <div class="card">
                <form id="editor-form">
                    <textarea id="editor" name="template_content"><?php echo htmlspecialchars($template_content); ?></textarea>
                    <br><br>
                    <button type="submit" class="btn btn-primary">保存模板</button>
                </form>
            </div>
        </div>
    </div>
    <script src="assets/script.js"></script>
</body>
</html>