<?php
require_once '../core/functions.php';
check_admin_login();
require_once '../core/db.php';

$stmt = $pdo->query("SELECT COUNT(*) FROM users");
$user_count = $stmt->fetchColumn();

$page_title = "仪表盘";
?>
<!DOCTYPE html>
<html lang="zh-CN">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $page_title; ?> - 后台管理</title>
    <link rel="stylesheet" href="assets/style.css">
</head>
<body>
    <div class="admin-wrapper">
        <?php include '_sidebar.php'; ?>
        <div class="main-content">
            <div class="content-header">
                <h1><?php echo $page_title; ?></h1>
            </div>
            <div class="card">
                <h2>欢迎, <?php echo htmlspecialchars($_SESSION['admin_username']); ?>!</h2>
                <p>这里是你的管理后台，从左侧菜单开始操作吧。</p>
            </div>
            <div class="card">
                <h2>数据概览</h2>
                <p>当前注册用户总数: <strong><?php echo $user_count; ?></strong></p>
            </div>
        </div>
    </div>
    <script src="assets/script.js"></script>
</body>
</html>