document.addEventListener('DOMContentLoaded', function() {

    // Toast 提示函数
    const showToast = (message, type = 'success') => {
        let container = document.getElementById('toast-container');
        if (!container) {
            container = document.createElement('div');
            container.id = 'toast-container';
            document.body.appendChild(container);
        }

        const toast = document.createElement('div');
        toast.className = `toast ${type}`;
        toast.textContent = message;
        container.appendChild(toast);

        setTimeout(() => {
            toast.classList.add('show');
        }, 100);

        setTimeout(() => {
            toast.classList.remove('show');
            setTimeout(() => {
                toast.remove();
                if (container.children.length === 0) {
                    container.remove();
                }
            }, 400);
        }, 3000);
    };

    // 封装的 fetch 请求
    const sendRequest = (formData) => {
        return fetch('ajax.php', {
            method: 'POST',
            body: formData
        }).then(response => response.json());
    };
    
    // 侧边栏收缩/展开逻辑
    const sidebar = document.getElementById('sidebar');
    const sidebarToggle = document.getElementById('sidebar-toggle');
    const body = document.body;

    const toggleSidebar = () => {
        if (window.innerWidth <= 768) { // 移动端
            sidebar.classList.toggle('expanded');
        } else { // PC端
            sidebar.classList.toggle('collapsed');
            body.classList.toggle('sidebar-collapsed');
        }
    };

    if (sidebarToggle) {
        sidebarToggle.addEventListener('click', toggleSidebar);
    }
    
    // 检查并设置初始PC端侧边栏状态
    if (window.innerWidth > 768 && localStorage.getItem('sidebar_collapsed') === 'true') {
        sidebar.classList.add('collapsed');
        body.classList.add('sidebar-collapsed');
    }
    
    // 保存PC端侧边栏状态
    const saveSidebarState = () => {
        if (window.innerWidth > 768) {
            if (sidebar.classList.contains('collapsed')) {
                localStorage.setItem('sidebar_collapsed', 'true');
            } else {
                localStorage.setItem('sidebar_collapsed', 'false');
            }
        }
    };
    
    if (sidebarToggle) {
        sidebarToggle.addEventListener('click', saveSidebarState);
    }

    // 保存设置
    const settingsForm = document.getElementById('settings-form');
    if (settingsForm) {
        settingsForm.addEventListener('submit', function(e) {
            e.preventDefault();
            const formData = new FormData(this);
            formData.append('action', 'save_settings');
            sendRequest(formData).then(data => {
                showToast(data.message, data.status);
            });
        });
    }

    // 添加弹窗文字
    const addTipForm = document.getElementById('add-tip-form');
    if (addTipForm) {
        addTipForm.addEventListener('submit', function(e) {
            e.preventDefault();
            const formData = new FormData(this);
            formData.append('action', 'add_tip');
            sendRequest(formData).then(data => {
                if (data.status === 'success') {
                    const tableBody = document.getElementById('tips-table').querySelector('tbody');
                    const newRow = document.createElement('tr');
                    newRow.dataset.id = data.id;
                    newRow.innerHTML = `<td>${data.content}</td><td><button class="btn btn-danger btn-sm delete-tip">删除</button></td>`;
                    tableBody.insertBefore(newRow, tableBody.firstChild);
                    addTipForm.reset();
                }
                showToast(data.message, data.status);
            });
        });
    }

    // 删除弹窗文字
    const tipsTable = document.getElementById('tips-table');
    if (tipsTable) {
        tipsTable.addEventListener('click', function(e) {
            if (e.target.classList.contains('delete-tip')) {
                if (!confirm('确定要删除这条文字吗？')) return;
                const row = e.target.closest('tr');
                const id = row.dataset.id;
                const formData = new FormData();
                formData.append('action', 'delete_tip');
                formData.append('id', id);
                sendRequest(formData).then(data => {
                    if (data.status === 'success') {
                        row.remove();
                    }
                    showToast(data.message, data.status);
                });
            }
        });
    }

    // 修改密码
    const passwordForm = document.getElementById('password-form');
    if (passwordForm) {
        passwordForm.addEventListener('submit', function(e) {
            e.preventDefault();
            const formData = new FormData(this);
            formData.append('action', 'update_password');
            sendRequest(formData).then(data => {
                showToast(data.message, data.status);
                if (data.status === 'success') {
                    passwordForm.reset();
                }
            });
        });
    }
    
    // 删除用户
    document.body.addEventListener('click', function(e) {
        if (e.target.classList.contains('delete-user')) {
            if (!confirm('警告：删除用户会同时删除他所有自定义的数据，确定吗？')) return;
            const row = e.target.closest('tr');
            const id = row.dataset.id;
            const formData = new FormData();
            formData.append('action', 'delete_user');
            formData.append('id', id);
            sendRequest(formData).then(data => {
                if (data.status === 'success') {
                    row.remove();
                }
                showToast(data.message, data.status);
            });
        }
    });
    
    // 切换用户权限
    document.body.addEventListener('change', function(e) {
        if (e.target.classList.contains('permission-toggle')) {
            const row = e.target.closest('tr');
            const id = row.dataset.id;
            const permission = e.target.dataset.permission;
            const value = e.target.checked ? 1 : 0;
            const formData = new FormData();
            formData.append('action', 'toggle_permission');
            formData.append('id', id);
            formData.append('permission', permission);
            formData.append('value', value);
            sendRequest(formData).then(data => {
                showToast(data.message, data.status);
            });
        }
    });
    
    // 保存模板
    const editorForm = document.getElementById('editor-form');
    if (editorForm) {
        editorForm.addEventListener('submit', function(e) {
            e.preventDefault();
            const content = document.getElementById('editor').value;
            const formData = new FormData();
            formData.append('action', 'save_template');
            formData.append('content', content);
            sendRequest(formData).then(data => {
                showToast(data.message, data.status);
            });
        });
    }
});