<?php
require_once '../core/functions.php';
if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
    echo json_encode(['status' => 'error', 'message' => '未授权的访问']);
    exit;
}
require_once '../core/db.php';

header('Content-Type: application/json');

$action = $_POST['action'] ?? '';
$response = ['status' => 'error', 'message' => '无效的操作'];

try {
    switch ($action) {
        case 'save_settings':
            unset($_POST['action']);
            foreach ($_POST as $key => $value) {
                $stmt = $pdo->prepare("INSERT INTO settings (setting_key, setting_value) VALUES (?, ?) ON DUPLICATE KEY UPDATE setting_value = ?");
                $stmt->execute([$key, $value, $value]);
            }
            $response = ['status' => 'success', 'message' => '设置已保存'];
            break;

        case 'add_tip':
            $content = trim($_POST['content'] ?? '');
            if (!empty($content)) {
                $stmt = $pdo->prepare("INSERT INTO tips (content) VALUES (?)");
                $stmt->execute([$content]);
                $new_id = $pdo->lastInsertId();
                $response = ['status' => 'success', 'message' => '文字已添加', 'id' => $new_id, 'content' => htmlspecialchars($content)];
            } else {
                $response['message'] = '内容不能为空';
            }
            break;

        case 'delete_tip':
            $id = intval($_POST['id'] ?? 0);
            if ($id > 0) {
                $stmt = $pdo->prepare("DELETE FROM tips WHERE id = ?");
                $stmt->execute([$id]);
                $response = ['status' => 'success', 'message' => '文字已删除'];
            }
            break;

        case 'update_password':
            $new_password = $_POST['new_password'] ?? '';
            $confirm_password = $_POST['confirm_password'] ?? '';
            if (empty($new_password) || $new_password !== $confirm_password) {
                $response['message'] = '两次输入的密码不一致或为空';
            } elseif (strlen($new_password) < 6) {
                $response['message'] = '密码长度不能少于6位';
            } else {
                $hashed_password = password_hash($new_password, PASSWORD_DEFAULT);
                $stmt = $pdo->prepare("UPDATE admins SET password = ? WHERE id = ?");
                $stmt->execute([$hashed_password, $_SESSION['admin_id']]);
                $response = ['status' => 'success', 'message' => '密码修改成功'];
            }
            break;

        case 'delete_user':
            $id = intval($_POST['id'] ?? 0);
            if ($id > 0) {
                $pdo->beginTransaction();
                $stmt1 = $pdo->prepare("DELETE FROM users WHERE id = ?");
                $stmt1->execute([$id]);
                $stmt2 = $pdo->prepare("DELETE FROM user_pages WHERE user_id = ?");
                $stmt2->execute([$id]);
                $pdo->commit();
                $response = ['status' => 'success', 'message' => '用户及其数据已删除'];
            }
            break;

        case 'toggle_permission':
            $id = intval($_POST['id'] ?? 0);
            $permission = $_POST['permission'] ?? '';
            $value = intval($_POST['value'] ?? 0);
            $allowed_permissions = ['can_use_music', 'can_use_effects', 'can_generate_link'];
            if ($id > 0 && in_array($permission, $allowed_permissions)) {
                $stmt = $pdo->prepare("UPDATE users SET {$permission} = ? WHERE id = ?");
                $stmt->execute([$value, $id]);
                $response = ['status' => 'success', 'message' => '权限已更新'];
            }
            break;
            
        case 'save_template':
            $content = $_POST['content'] ?? '';
            $path = '../templates/popup_template.php';
            if (file_put_contents($path, $content) !== false) {
                $response = ['status' => 'success', 'message' => '模板文件已保存'];
            } else {
                $response['message'] = '模板文件保存失败，请检查权限';
            }
            break;
    }
} catch (Exception $e) {
    if ($pdo->inTransaction()) {
        $pdo->rollBack();
    }
    $response['message'] = '操作失败: ' . $e->getMessage();
}

echo json_encode($response);
?>